/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.chunk_loading;

import java.util.Objects;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.chunk_loading.DimensionalChunkPos;
import qouteall.imm_ptl.core.chunk_loading.LenientChunkRegion;
import qouteall.imm_ptl.core.chunk_loading.NewChunkTrackingGraph;
import qouteall.q_misc_util.MiscHelper;
import qouteall.q_misc_util.my_util.MyTaskList;

public class ChunkLoader {
    public DimensionalChunkPos center;
    public int radius;
    @Deprecated
    public boolean isDirectLoader = false;

    public ChunkLoader(DimensionalChunkPos center, int radius) {
        this(center, radius, false);
    }

    public ChunkLoader(DimensionalChunkPos center, int radius, boolean isDirectLoader) {
        this.center = center;
        this.radius = radius;
        this.isDirectLoader = isDirectLoader;
    }

    public int getLoadedChunkNum() {
        int[] numBox = new int[]{0};
        this.foreachChunkPos((dim, x, z, dist) -> {
            if (McHelper.isServerChunkFullyLoaded(McHelper.getServerWorld((ResourceKey<Level>)dim), new ChunkPos(x, z))) {
                numBox[0] = numBox[0] + 1;
            }
        });
        return numBox[0];
    }

    public int getChunkNum() {
        return (this.radius * 2 + 1) * (this.radius * 2 + 1);
    }

    public void foreachChunkPos(ChunkPosConsumer func) {
        for (int dx = -this.radius; dx <= this.radius; ++dx) {
            for (int dz = -this.radius; dz <= this.radius; ++dz) {
                func.consume(this.center.dimension, this.center.x + dx, this.center.z + dz, Math.max(Math.abs(dx), Math.abs(dz)));
            }
        }
    }

    public LenientChunkRegion createChunkRegion() {
        ServerLevel world = MiscHelper.getServer().m_129880_(this.center.dimension);
        return LenientChunkRegion.createLenientChunkRegion(this.center, this.radius, world);
    }

    public void loadChunksAndDo(Runnable runnable) {
        NewChunkTrackingGraph.addGlobalAdditionalChunkLoader(this);
        IPGlobal.serverTaskList.addTask(MyTaskList.withDelayCondition(() -> this.getLoadedChunkNum() < this.getChunkNum(), MyTaskList.oneShotTask(() -> {
            NewChunkTrackingGraph.removeGlobalAdditionalChunkLoader(this);
            runnable.run();
        })));
    }

    public String toString() {
        return "{center=" + String.valueOf(this.center) + ", radius=" + this.radius + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChunkLoader that = (ChunkLoader)o;
        return this.radius == that.radius && this.center.equals(that.center);
    }

    public int hashCode() {
        return Objects.hash(this.center, this.radius);
    }

    public static interface ChunkPosConsumer {
        public void consume(ResourceKey<Level> var1, int var2, int var3, int var4);
    }
}

